#pragma once

#include "combined_key_id.h"

#include <passport/infra/libs/cpp/auth_core/random.h>

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/datetime/base.h>

#include <optional>

namespace NPassport::NAuth {
    struct TGamma;

    class TKeyWithGamma {
    public:
        TKeyWithGamma(const TRandom& random, const TGamma& gamma);
        TKeyWithGamma(const TRandom& random, TRandom::EView randomView);
        TKeyWithGamma(TString&& error);

        template <typename... Str>
        static TKeyWithGamma FromError(const Str&... args) {
            return TKeyWithGamma(NUtils::CreateStr(args...));
        }

        const TString& Error() const;
        const TString& Body() const;
        TCombinedKeyId Id() const;

        bool IsCreateTimeValid(TInstant created) const;

        void SetValidUpperBound(TInstant upperBound);
        void Update(const TRandom& random, TRandom::EView randomView);

    public:
        static TString MakeXor(const TStringBuf left, const TStringBuf right);

    private:
        TString Err_;

        TString Body_;
        TCombinedKeyId CombinedId_;

        std::optional<TInstant> ValidUpperBound_;
    };
}
