#pragma once

#include <library/cpp/string_utils/secret_string/secret_string.h>

#include <util/generic/hash.h>
#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

namespace NPassport::NAuth {
    class TKeyMap: public TMoveOnly { // NOLINT(bugprone-exception-escape)
    public:
        static TKeyMap CreateFromFile(const TString& filename, unsigned defaultid);
        static TKeyMap CreateFromRawMap(const THashMap<unsigned, TString>& map, unsigned defaultid); // for tests

        size_t GetSize() const;

        bool HasKey(const TStringBuf id) const;
        bool HasKey(unsigned id) const;

        TZtStringBuf GetKey(const TStringBuf id) const;
        TZtStringBuf GetKey(unsigned id) const;

        const TString& GetDefaultId() const;
        unsigned GetDefaultIdNum() const;
        TZtStringBuf GetDefaultKey() const;

    private:
        void SetDefaultId(unsigned id);

        THashMap<ui32, NSecretString::TSecretString> Keys_;
        TString DefaultIdStr_;
        ui32 DefaultIdNum_ = 0;
        NSecretString::TSecretString DefaultKey_;
    };
}
