#include "oauth_token.h"

namespace NPassport::NAuth {
    TOAuthToken::TOAuthToken() = default;

    TOAuthToken::~TOAuthToken() = default;

    const TString& TOAuthToken::TokenId() const {
        if (TokenId_.empty()) { // rebuild token_id, concatenate time and uid
            TokenId_ = TokenIdTime_ + (Uid_.empty() ? "0" : Uid_);
        }
        return TokenId_;
    }

    TString TOAuthToken::TokenIdTime() const {
        TString result(TokenIdTime_);
        if (result.size() > 3) {
            result.resize(result.size() - 3); // cut off ms part
        }
        return result;
    }

    void TOAuthToken::SetTokenIdTime(const TString& time) {
        TokenIdTime_.assign(time);
        TokenId_.clear(); // rebuild later if needed
    }

}
