#pragma once

#include <util/generic/string.h>

#include <atomic>
#include <memory>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NAuth {
    class TKeyRing;
    class TOAuthToken;
    struct TKeyRingSettings;

    class TOAuthTokenParser {
    public:
        static const TString KEYSPACE;

        TOAuthTokenParser(NDbPool::TDbPool& defaultdb, const TKeyRingSettings& settings);
        virtual ~TOAuthTokenParser();

        static TOAuthToken CreateToken(const TString& uid,
                                       time_t create_time,
                                       time_t expire_time,
                                       const TString& clientId,
                                       const TString& tokenIdTime);

        TOAuthToken ParseToken(const TString& strtoken) const;
        TString MakeTokenStr(const TOAuthToken& token, TString& err_msg) const;

        static bool CheckTokenIdTime(const TStringBuf val); // return true if OK

        NJuggler::TStatus GetJugglerStatus() const;

    protected:
        void Run();

    private:
        const std::shared_ptr<TKeyRing> Keyring_;
    };
}
