#pragma once

#include <util/system/types.h>

namespace NPassport::NAuth {
    class TPublicId {
    public:
        enum EStatus {
            VALID,
            BROKEN,
        };

        TPublicId();
        TPublicId(ui64 uid, ui8 version);

        EStatus Status() const {
            return Status_;
        }
        ui64 Uid() const {
            return Uid_;
        }
        ui8 Version() const {
            return Version_;
        }

    private:
        friend class TPublicIdEncryptor;

        EStatus Status_ = BROKEN;
        ui64 Uid_ = 0;
        ui8 Version_ = 0;
    };
}
