#include "random.h"

#include <passport/infra/libs/cpp/utils/crypto/hash.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/string/cast.h>

namespace NPassport::NAuth {
    TRandom::TRandom(const TString& id, const TString& body, time_t start)
        : Id_(id)
        , StartTime_(TInstant::Seconds(start))
        , Iid_(IntFromString<int, 10>(id))
    {
        TString binBody = NUtils::Hex2bin(body);
        TString bodyHash = NUtils::TCrypto::Sha256(binBody);

        // TSecretString calls madvise(): it is expensive for kernel.
        // So we are trying to reduce madvise() calls.
        // PASSP-32654
        SecuredBuf_ = NUtils::CreateStr(body, binBody, bodyHash);
        TStringBuf tmpSecuredBuf = SecuredBuf_;

        auto cutHead = [&tmpSecuredBuf](size_t size) {
            TStringBuf res = tmpSecuredBuf.Head(size);
            tmpSecuredBuf.Skip(size);
            return res;
        };

        Body_ = cutHead(body.size());
        BinBody_ = cutHead(binBody.size());
        BodyHash_ = cutHead(bodyHash.size());

        Y_VERIFY(tmpSecuredBuf.empty());
        Y_VERIFY(Body_ == body);
        Y_VERIFY(BinBody_ == binBody);
        Y_VERIFY(BodyHash_ == bodyHash);
    }
}
