#pragma once

#include <library/cpp/string_utils/secret_string/secret_string.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <ctime>

namespace NPassport::NAuth {
    class TRandom: TNonCopyable {
    public:
        enum EView {
            Body,
            BinBody,
            BodyHash,
        };

        TRandom(const TString& id, const TString& body, time_t start);

        TRandom(TRandom&&) = delete;
        TRandom& operator=(TRandom&&) = delete;

        const TString& Id() const {
            return Id_;
        }

        TStringBuf GetBody() const {
            return Body_;
        }

        TStringBuf GetBinBody() const {
            return BinBody_;
        }

        TStringBuf GetBodyHash() const {
            return BodyHash_;
        }

        TInstant StartTime() const {
            return StartTime_;
        }

        int IntId() const {
            return Iid_;
        }

        TStringBuf Get(EView randomView) const {
            switch (randomView) {
                case EView::Body:
                    return GetBody();
                case EView::BinBody:
                    return GetBinBody();
                case EView::BodyHash:
                    return GetBodyHash();
            }
        }

    private:
        NSecretString::TSecretString SecuredBuf_;

        const TString Id_;
        TStringBuf Body_;
        TStringBuf BinBody_;
        TStringBuf BodyHash_;
        const TInstant StartTime_;
        const int Iid_;
    };

    using TRandomPtr = std::shared_ptr<TRandom>;
}
