#pragma once

#include <util/generic/string.h>
#include <util/system/types.h>

#include <time.h>

namespace NPassport::NAuth {
    class TSessGuard {
    public:
        enum EStatus {
            VALID,
            INVALID
        };

        TSessGuard(const TString& authId);

        ~TSessGuard();

        EStatus Status() const {
            return Status_;
        }

        const TString& ErrMsg() const {
            return ErrMsg_;
        }

        unsigned Version() const {
            return Version_;
        }

        time_t CreateTime() const {
            return Created_;
        }

        const TString& AuthId() const {
            return AuthId_;
        }

        const TString& Keyspace() const {
            return Keyspace_;
        }

        const TString& Guardspace() const {
            return Guardspace_;
        }

    private:
        friend class TSessGuardParser;

        TSessGuard();

        EStatus Status_ = INVALID;
        TString ErrMsg_;

        // sessguard version
        unsigned Version_ = 1;

        time_t Created_ = 0;

        TString AuthId_;
        TString Keyspace_;
        TString Guardspace_;
    };
}
