#pragma once

#include "sessguard.h"

#include <util/generic/hash.h>

#include <vector>

namespace NPassport::NAuth {
    class TSessionSigner;

    class TSessGuardParser {
    public:
        explicit TSessGuardParser(TSessionSigner& sessSigner);

        const TSessionSigner& SessSigner() const {
            return SessSigner_;
        }

        // add guard space and remember which host name parts map to this guard space
        void AddGuardSpace(const TString& id, const TString& spacename, const std::vector<TString>& allowed_hostnames);
        const TString& GetGuardSpace(TStringBuf hostname, TStringBuf domsuff) const;

        TSessGuard ParseGuard(const TString& strGuard,
                              const TString& hostname) const;
        TString MakeGuardStr(const TSessGuard& guard,
                             const TString& hostname,
                             TString& domain,
                             time_t now = time(nullptr)) const;

    private:
        TSessionSigner& SessSigner_;

        // mapping: hostname part -> guardspace
        // i.e. hostname 'passport-dev' maps to 'guard_passport' guard space
        THashMap<TString, TString> HostnameMap_;
    };
}
