#include "sessionutils.h"

#include "session.h"
#include "sessionparser.h"

#include <passport/infra/libs/cpp/utils/ipaddr.h>
#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/format.h>

#include <algorithm>

namespace NPassport::NAuth {
    TString TSessionUtils::Dots2under(const TStringBuf src) {
        TString res(src);
        DomainToKeyspace(res);
        return res;
    }

    static const TString ZERO_ = "0";
    NUtils::TIpAddr TSessionUtils::ParseEncodedIp(const TStringBuf ip) {
        const TStringBuf binIp = ip.empty() ? TStringBuf(ZERO_) : ip;

        NUtils::TIpAddr addr;
        if (!addr.ParseBase64(binIp)) {
            TLog::Warning() << "Couldn't convert v3 IP from authid: " << ip;
        }

        return addr;
    }

    TString TSessionUtils::RepairCookie(const TStringBuf session) {
        TString result = NUtils::Unquote(session);

        // check if session is double-urlencoded
        if (result.find('%') != TString::npos) {
            result = NUtils::Urldecode(result);
        }

        return result;
    }

    void TSessionUtils::KeyspaceToDomain(TString& keyspace) {
        std::replace(keyspace.begin(), keyspace.vend(), '_', '.');
    }

    void TSessionUtils::DomainToKeyspace(TString& domain) {
        std::replace(domain.begin(), domain.vend(), '.', '_');
    }

}
