#include "common.h"

#include <passport/infra/libs/cpp/auth_core/oauth_token_parser.h>
#include <passport/infra/libs/cpp/auth_core/sessionsigner.h>

#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/destination.h>

#include <library/cpp/testing/unittest/env.h>

namespace NPassport::NAuth {
    TTestDbHolder::TTestDbHolder() {
        const NDbPool::TDestinationPtr dsn = NDbPool::TDestination::CreateSqlite(ArcadiaSourceRoot() + "/passport/infra/libs/cpp/auth_core/ut/db/keys.sql");
        Pool_ = std::make_unique<NDbPool::TDbPool>(NDbPool::TDbPoolSettings{
            .Dsn = dsn,
        });
    }

    NDbPool::TDbPool& TTestDbHolder::Pool() {
        // use one dbpool for all tests
        static TTestDbHolder instance;

        return *instance.Pool_;
    }

}
