#include <passport/infra/libs/cpp/auth_core/gamma/combined_key_id.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NAuth;

Y_UNIT_TEST_SUITE(GammaCombinedKeyId) {
    static void Check(TCombinedKeyId toTest, ui32 gammaid, ui32 randomid) {
        UNIT_ASSERT_VALUES_EQUAL_C(toTest.GammaId(), gammaid, toTest.AsNumber());
        UNIT_ASSERT_VALUES_EQUAL_C(toTest.RandomId(), randomid, toTest.AsNumber());
    }

    Y_UNIT_TEST(common) {
        Check(TCombinedKeyId(), 0, 0);

        Check(TCombinedKeyId(0, 456), 0, 456);
        Check(TCombinedKeyId(422, 0), 422, 0);
        Check(TCombinedKeyId(213, 456), 213, 456);
        Check(TCombinedKeyId(422, 213), 422, 213);

        Check(TCombinedKeyId(420000213), 42, 213);
        Check(TCombinedKeyId(4200000213), 420, 213);

        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TCombinedKeyId(456, 0),
            yexception,
            "gammaId=456 is too big, max=429, randomid=0");

        UNIT_ASSERT_VALUES_EQUAL(TCombinedKeyId(422, 213).AsNumber(), 4220000213);
        UNIT_ASSERT_VALUES_EQUAL(TCombinedKeyId(422, 213).AsString(), "4220000213");
    }
}

template <>
void Out<TCombinedKeyId>(IOutputStream& out, const TCombinedKeyId& value) {
    out << value.AsNumber();
}
