#include "common.h"

#include <passport/infra/libs/cpp/auth_core/keyring.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

using namespace NPassport::NAuth;

Y_UNIT_TEST_SUITE(PasspAuthCoreKeyRing) {
    Y_UNIT_TEST(createFromFile) {
        SetEnv("TZ", "Europe/Moscow");
        tzset();

        TKeyRing k(TTestDbHolder::Pool(), "yandex_ru", {});

        UNIT_ASSERT_VALUES_EQUAL("yandex_ru", k.KSpace());
        UNIT_ASSERT_VALUES_EQUAL("yandex.ru", k.DomSuff());
        UNIT_ASSERT_VALUES_EQUAL("3", k.GroupId());

        TStringStream s;
        k.PrintAsTxt(s);

        UNIT_ASSERT_VALUES_EQUAL(
            s.Str(),
            "32841;e56dbf6ed77f97d6899bdb086b0d89bf;1296889201\n"
            "32840;797ba9f39780e481f1b642d0f629f145;1296885601\n"
            "32838;943d668a2e446701dff2f4c950d8b7ad;1296878401\n"
            "32837;75a32928bd114c1b5d462f20e3533c2e;1296874801\n"
            "32836;e56dbf6ed77f97d6899bdb086b0d89bf;1296871201\n");

        TKeyRing k2(TTestDbHolder::Pool(), "signsmth", {});

        UNIT_ASSERT_VALUES_EQUAL("signsmth", k2.KSpace());
        UNIT_ASSERT_VALUES_EQUAL("", k2.DomSuff());
        UNIT_ASSERT_VALUES_EQUAL("22", k2.GroupId());
    }
}
