#include <passport/infra/libs/cpp/auth_core/random.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NAuth;

Y_UNIT_TEST_SUITE(Random) {
    Y_UNIT_TEST(get) {
        const TRandom random("123", "0123456789", 42);

        struct TCase {
            TRandom::EView View;
            TString Body;
        };
        std::vector<TCase> cases = {
            TCase{
                .View = TRandom::Body,
                .Body = "30313233343536373839",
            },
            TCase{
                .View = TRandom::BinBody,
                .Body = "0123456789",
            },
            TCase{
                .View = TRandom::BodyHash,
                .Body = "db24abe2d0a20fac957859eb755b3dbf695becdb9f5890e3a2a2411273ae50ad",
            },
        };

        for (const TCase& c : cases) {
            UNIT_ASSERT_VALUES_EQUAL_C(c.Body, NUtils::Bin2hex(random.Get(c.View)), c.View);
        }
    }
}
