#include <passport/infra/libs/cpp/auth_core/sessionutils.h>

#include <passport/infra/libs/cpp/utils/ipaddr.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/string.h>

using namespace NPassport::NAuth;
using namespace NPassport::NUtils;

Y_UNIT_TEST_SUITE(PasspAuthUtils) {
    Y_UNIT_TEST(domain) {
        UNIT_ASSERT_VALUES_EQUAL("asd", TSessionUtils::Dots2under("asd"));
        UNIT_ASSERT_VALUES_EQUAL("as_d", TSessionUtils::Dots2under("as_d"));
        UNIT_ASSERT_VALUES_EQUAL("a_s_d", TSessionUtils::Dots2under("a.s_d"));

        TString s = "a.s_d";
        TSessionUtils::KeyspaceToDomain(s);
        UNIT_ASSERT_VALUES_EQUAL("a.s.d", s);
        TSessionUtils::DomainToKeyspace(s);
        UNIT_ASSERT_VALUES_EQUAL("a_s_d", s);
    }

    Y_UNIT_TEST(repair) {
        UNIT_ASSERT_VALUES_EQUAL("", TSessionUtils::RepairCookie(""));
        UNIT_ASSERT_VALUES_EQUAL("as_d", TSessionUtils::RepairCookie(R"("as_d")"));
        UNIT_ASSERT_VALUES_EQUAL("O*&TV&^TVA(B*AF", TSessionUtils::RepairCookie("O%2A%26TV%26%5ETVA%28B%2AAF"));
        UNIT_ASSERT_VALUES_EQUAL("O*&TV&^TVA(B*AF", TSessionUtils::RepairCookie(R"("O%2A%26TV%26%5ETVA%28B%2AAF")"));
    }

    Y_UNIT_TEST(parseIp) {
        TIpAddr addr;
        addr.Parse("127.0.0.1");
        UNIT_ASSERT_EQUAL(addr, TSessionUtils::ParseEncodedIp("AQAAfw"));
        addr = TIpAddr();
        UNIT_ASSERT_EQUAL(addr, TSessionUtils::ParseEncodedIp("****"));
    }
}
