LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    passport/infra/libs/cpp/auth_core/proto
    passport/infra/libs/cpp/dbpool
    passport/infra/libs/cpp/juggler
    library/cpp/string_utils/secret_string
    contrib/libs/libxml
)

SRCS(
    gamma/combined_key_id.cpp
    gamma/gamma_keeper.cpp
    gamma/key_with_gamma.cpp
    keymap.cpp
    keyring.cpp
    oauth_token.cpp
    oauth_token_parser.cpp
    public_id.cpp
    public_id_encryptor.cpp
    random.cpp
    sessguard.cpp
    sessguard_parser.cpp
    session.cpp
    sessionparser.cpp
    sessionsigner.cpp
    sessionutils.cpp
)

GENERATE_ENUM_SERIALIZATION(environment.h)
GENERATE_ENUM_SERIALIZATION(gamma/gamma.h)
GENERATE_ENUM_SERIALIZATION(oauth_token.h)
GENERATE_ENUM_SERIALIZATION(public_id.h)
GENERATE_ENUM_SERIALIZATION(random.h)
GENERATE_ENUM_SERIALIZATION(session_errors.h)
GENERATE_ENUM_SERIALIZATION(session.h)
GENERATE_ENUM_SERIALIZATION(sessguard.h)

END()

RECURSE_FOR_TESTS(
    ut
)
