#pragma once

#include <util/generic/yexception.h>
#include <util/system/types.h>

namespace NPassport::NCache {
    class TCyclicIdx {
    public:
        TCyclicIdx(ui32 idx, ui32 max)
            : Max_(max)
        {
            Y_ENSURE(Max_ > 0);

            OriginalIdx_ = idx % Max_;
            Idx_ = OriginalIdx_;
        }

        bool Forward() {
            Idx_ += 1;
            Idx_ %= Max_;
            return Idx_ != OriginalIdx_;
        }

        bool Backward() {
            Idx_ += Max_ - 1;
            Idx_ %= Max_;
            return Idx_ != OriginalIdx_;
        }

        ui32 GetValue() const {
            return Idx_;
        }

    protected:
        ui32 OriginalIdx_;
        ui32 Idx_;
        const ui32 Max_;
    };
}
