#include <passport/infra/libs/cpp/cache/cyclic_idx.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

using namespace NPassport::NCache;

Y_UNIT_TEST_SUITE(CyclicIdx) {
    class TCyclicIdxTest: public TCyclicIdx {
    public:
        using TCyclicIdx::Idx_;
        using TCyclicIdx::Max_;
        using TCyclicIdx::OriginalIdx_;
        using TCyclicIdx::TCyclicIdx;
    };

    Y_UNIT_TEST(ctor) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TCyclicIdxTest(0, 0),
                                       yexception,
                                       "Condition violated: `Max_ > 0'");

        TCyclicIdxTest idx(0, 1);
        UNIT_ASSERT_VALUES_EQUAL(0, idx.Idx_);
        UNIT_ASSERT_VALUES_EQUAL(0, idx.OriginalIdx_);
        UNIT_ASSERT_VALUES_EQUAL(1, idx.Max_);

        TCyclicIdxTest idx2(90, 100);
        UNIT_ASSERT_VALUES_EQUAL(90, idx2.Idx_);
        UNIT_ASSERT_VALUES_EQUAL(90, idx2.OriginalIdx_);
        UNIT_ASSERT_VALUES_EQUAL(100, idx2.Max_);
    }

    Y_UNIT_TEST(foreward) {
        TCyclicIdxTest idx(4, 5);

        UNIT_ASSERT_VALUES_EQUAL(4, idx.GetValue());

        UNIT_ASSERT(idx.Forward());
        UNIT_ASSERT_VALUES_EQUAL(0, idx.GetValue());
        UNIT_ASSERT(idx.Forward());
        UNIT_ASSERT_VALUES_EQUAL(1, idx.GetValue());
        UNIT_ASSERT(idx.Forward());
        UNIT_ASSERT_VALUES_EQUAL(2, idx.GetValue());
        UNIT_ASSERT(idx.Forward());
        UNIT_ASSERT_VALUES_EQUAL(3, idx.GetValue());
        UNIT_ASSERT(!idx.Forward());
        UNIT_ASSERT_VALUES_EQUAL(4, idx.GetValue());
    }

    Y_UNIT_TEST(backward) {
        TCyclicIdxTest idx(4, 5);

        UNIT_ASSERT_VALUES_EQUAL(4, idx.GetValue());

        UNIT_ASSERT(idx.Backward());
        UNIT_ASSERT_VALUES_EQUAL(3, idx.GetValue());
        UNIT_ASSERT(idx.Backward());
        UNIT_ASSERT_VALUES_EQUAL(2, idx.GetValue());
        UNIT_ASSERT(idx.Backward());
        UNIT_ASSERT_VALUES_EQUAL(1, idx.GetValue());
        UNIT_ASSERT(idx.Backward());
        UNIT_ASSERT_VALUES_EQUAL(0, idx.GetValue());
        UNIT_ASSERT(!idx.Backward());
        UNIT_ASSERT_VALUES_EQUAL(4, idx.GetValue());
    }
}
