#include <passport/infra/libs/cpp/cache/key_based_bucket.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

using namespace NPassport::NCache;

Y_UNIT_TEST_SUITE(KeyBasedBucket) {
    class TTKeyBasedBucketTest: public TKeyBasedBucket<TString, TString> {
    public:
    };

    Y_UNIT_TEST(common) {
        TTKeyBasedBucketTest bucket;
        UNIT_ASSERT_VALUES_EQUAL(0, bucket.GetTotalSize());

        TInstant now = TInstant::Now();
        UNIT_ASSERT(!bucket.Get("kek", now));

        bucket.Put("kek", "lol", now + TDuration::Days(1));
        UNIT_ASSERT_VALUES_EQUAL(6, bucket.GetTotalSize());

        std::optional<TString> v = bucket.Get("kek", now);
        UNIT_ASSERT(v);
        UNIT_ASSERT_VALUES_EQUAL("lol", *v);

        v = bucket.Get("kek", now + TDuration::Days(1) - TDuration::Seconds(1));
        UNIT_ASSERT(v);
        UNIT_ASSERT_VALUES_EQUAL("lol", *v);

        v = bucket.Get("kek", now + TDuration::Days(1));
        UNIT_ASSERT(!v);

        bucket.Put("kek", "lol12345", now + TDuration::Hours(1));
        UNIT_ASSERT_VALUES_EQUAL(11, bucket.GetTotalSize());

        v = bucket.Get("kek", now + TDuration::Hours(1) - TDuration::Seconds(1));
        UNIT_ASSERT(v);
        UNIT_ASSERT_VALUES_EQUAL("lol12345", *v);

        v = bucket.Get("kek", now + TDuration::Hours(1));
        UNIT_ASSERT(!v);
    }

    Y_UNIT_TEST(clean) {
        TTKeyBasedBucketTest bucket;

        UNIT_ASSERT_VALUES_EQUAL(0, bucket.GetTotalSize());
        UNIT_ASSERT_VALUES_EQUAL(0, bucket.Clean());

        TInstant now = TInstant::Now();
        bucket.Put("kek", "lol", now + TDuration::Days(1));

        UNIT_ASSERT_VALUES_EQUAL(6, bucket.GetTotalSize());
        UNIT_ASSERT_VALUES_EQUAL(6, bucket.Clean());

        UNIT_ASSERT_VALUES_EQUAL(0, bucket.GetTotalSize());
        UNIT_ASSERT_VALUES_EQUAL(0, bucket.Clean());

        UNIT_ASSERT_VALUES_EQUAL(0, bucket.GetTotalSize());
    }

    Y_UNIT_TEST(isExpired) {
        TInstant now = TInstant::Now();
        UNIT_ASSERT(TTKeyBasedBucketTest::IsExpired(now, now));
        UNIT_ASSERT(TTKeyBasedBucketTest::IsExpired(now, now + TDuration::Seconds(1)));
        UNIT_ASSERT(!TTKeyBasedBucketTest::IsExpired(now + TDuration::Seconds(1), now));
    }
}
