#include <passport/infra/libs/cpp/cache/time_based_bucket.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

using namespace NPassport::NCache;

Y_UNIT_TEST_SUITE(TimeBasedBucket) {
    class TTimeBasedBucketTest: public TTimeBasedBucket<TString, TString> {
    public:
        using TTimeBasedBucket<TString, TString>::IsEmpty;
        using TTimeBasedBucket<TString, TString>::TTimeBasedBucket;
    };

    Y_UNIT_TEST(common) {
        TTimeBasedBucketTest bucket(2048);
        TInstant now = TInstant::Now();

        UNIT_ASSERT(!bucket.Get("kek", now));

        bucket.Put("kek", "lol", now + TDuration::Days(1));

        std::optional<TString> v = bucket.Get("kek", now);
        UNIT_ASSERT(v);
        UNIT_ASSERT_VALUES_EQUAL("lol", *v);

        v = bucket.Get("kek", now + TDuration::Days(1) - TDuration::Seconds(1));
        UNIT_ASSERT(v);
        UNIT_ASSERT_VALUES_EQUAL("lol", *v);

        v = bucket.Get("kek", now + TDuration::Days(1));
        UNIT_ASSERT(!v);
    }

    Y_UNIT_TEST(isEmpty) {
        TTimeBasedBucketTest bucket(2048);

        TInstant now = TInstant::Now();
        UNIT_ASSERT(bucket.IsEmpty(now));
        UNIT_ASSERT(bucket.IsEmpty(now + TDuration::Days(2)));

        UNIT_ASSERT(!bucket.Get("kek", now));

        bucket.Put("kek", "lol", now + TDuration::Days(1));
        UNIT_ASSERT(!bucket.IsEmpty(now));
        UNIT_ASSERT(bucket.IsEmpty(now + TDuration::Days(2)));

        UNIT_ASSERT(bucket.Get("kek", now));
        UNIT_ASSERT(!bucket.Get("kek", now + TDuration::Days(2)));
    }

    Y_UNIT_TEST(tryClean) {
        TTimeBasedBucketTest bucket(2048);

        TInstant now = TInstant::Now();
        UNIT_ASSERT_VALUES_EQUAL(0, bucket.TryClean(now).value());
        UNIT_ASSERT_VALUES_EQUAL(0, bucket.TryClean(now + TDuration::Days(2)).value());
        UNIT_ASSERT(bucket.IsEmpty(now));

        bucket.Put("kek", "lol", now + TDuration::Days(1));
        UNIT_ASSERT(!bucket.IsEmpty(now));

        UNIT_ASSERT(!bucket.TryClean(now));
        UNIT_ASSERT_VALUES_EQUAL(6, bucket.TryClean(now + TDuration::Days(2)).value());
        UNIT_ASSERT(!bucket.IsEmpty(now + TDuration::Days(1) - TDuration::Seconds(1)));
        UNIT_ASSERT(bucket.IsEmpty(now + TDuration::Days(1)));
    }
}
