#include "db_info.h"

#include "destination.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NDbPool {
    TDbInfo::TDbInfo(const TDestination& dsn)
        : Serialized(NUtils::CreateStr("dr=", dsn.Driver,
                                       ";db=", dsn.Db))
        , DisplayName(dsn.DisplayName)
        , Db(dsn.Db)
    {
    }

    TDbInfo::TDbInfo(const TDestination& dsn, const TDbHost& dbHost)
        : Serialized(NUtils::CreateStr("host=", dbHost.Host,
                                       ":", dbHost.Port,
                                       ";dr=", dsn.Driver,
                                       ";db=", dsn.Db))
        , DisplayName(dsn.DisplayName)
        , Db(dsn.Db)
    {
    }
}

template <>
void Out<NPassport::NDbPool::TDbInfo>(IOutputStream& o, const NPassport::NDbPool::TDbInfo& value) {
    o << value.Serialized;
}
