#include "db_pool.h"
#include "misc/db_pool.h"

#include "misc/handle.h"

namespace NPassport::NDbPool {
    TDbPool::TDbPool(const TDbPoolSettings& settings, const TDbPoolLog& logger)
        : Impl_(std::make_unique<NDbPool::TDbPoolImpl>(settings, logger))
    {
    }

    TDbPool::TDbPool(const TDbPoolSettings& settings)
        : TDbPool(settings, {})
    {
    }

    TDbPool::~TDbPool() = default;

    const TDbInfo& TDbPool::GetDbInfo() const {
        return Impl_->GetDbInfo();
    }

    bool TDbPool::IsOk(TString* status_buf) const {
        return Impl_->IsOk(status_buf);
    }

    THandlesInfo TDbPool::GetHandlesInfo() const {
        return Impl_->GetHandlesInfo();
    }

    void TDbPool::TryPing() {
        Impl_->TryPing();
    }

    void TDbPool::GetExtendedStats(NJson::TObject& out) const {
        Impl_->GetExtendedStats(out);
    }

    void TDbPool::AddUnistat(NUnistat::TBuilder& builder) const {
        Impl_->AddUnistat(builder);
    }

    void TDbPool::AddUnistatExtended(NUnistat::TBuilder& builder) const {
        Impl_->AddUnistatExtended(builder);
    }

    std::unique_ptr<THandle> TDbPool::Get() {
        return Impl_->Get();
    }

    void TDbPool::Put(std::unique_ptr<THandle> handle) {
        Impl_->Put(std::move(handle));
    }
}
