#pragma once

#include "db_info.h"
#include "db_pool_ctx.h"
#include "destination.h"
#include "handles_info.h"

#include <util/datetime/base.h>

#include <vector>

namespace NPassport::NJson {
    class TObject;
}

namespace NPassport::NDbPool {
    class TDbPoolImpl;
    class THandle;

    struct TDbPoolSettings {
        TDestinationPtr Dsn;
        std::vector<TDbHost> Hosts = {{}}; // non-empty array for tests
        size_t Size = 2;
        double TotalSizeRatio = 1.5;
        TDuration GetTimeout = TDuration::Seconds(10);
        TDuration ConnectionTimeout = TDuration::Seconds(10);
        TDuration QueryTimeout = TDuration::Seconds(20);
        TDuration FailThreshold = TDuration::MilliSeconds(500);
        TDuration PingPeriod = TDuration::Seconds(3);
        TDuration TimeToInit = TDuration::Seconds(2);

        TQueryOptsPtr DefaultQueryOpts = std::make_shared<TQueryOpts>();

        double BalancingCloseRate = 0.4;
        double BalancingOpenRate = 0.6;

        bool FetchStatusOnPing = false;
    };

    class TDbPool {
    public:
        TDbPool(const TDbPoolSettings& settings,
                const TDbPoolLog& logger);
        TDbPool(const TDbPoolSettings& settings); // for tests
        ~TDbPool();

        const TDbInfo& GetDbInfo() const;
        bool IsOk(TString* status_buf = nullptr) const;
        THandlesInfo GetHandlesInfo() const;
        void TryPing();
        void GetExtendedStats(NJson::TObject& out) const;

        void AddUnistat(NUnistat::TBuilder& builder) const;
        void AddUnistatExtended(NUnistat::TBuilder& builder) const;

    private:
        std::unique_ptr<THandle> Get();
        void Put(std::unique_ptr<THandle> handle);
        friend class TBlockingHandle;
        friend class TNonBlockingHandle;

    private:
        std::unique_ptr<TDbPoolImpl> Impl_;
    };
}
