#pragma once

#include "query.h"

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TTimeStat;
    class TBuilder;
}

namespace NPassport::NDbPool {
    class TCounters;
    class TDbPool;
    struct TDbPoolSettings;

    class TDbPoolCtx: public std::enable_shared_from_this<TDbPoolCtx> {
    public:
        using TTimeStat = std::shared_ptr<NUnistat::TTimeStat>;
        using TCounters = std::shared_ptr<NDbPool::TCounters>;

        struct TCredentials {
            TString User;
            TString Password;

            static TCredentials ReadFromFile(const TString& filename);
        };

    public:
        static std::shared_ptr<TDbPoolCtx> Create();

        void InitLogger(const TString& fileName);
        TDbPoolLog GetLogger() const;

        std::shared_ptr<TDbPool> CreateDb(const NXml::TConfig& config,
                                          const TString& xpath,
                                          TQueryOpts&& opts = {});
        std::shared_ptr<TDbPool> CreateDb(const NXml::TConfig& config,
                                          const TString& xpathSpecial,
                                          const TString& xpathCommon,
                                          TQueryOpts&& opts = {});

        std::shared_ptr<TDbPool> CreateDb(const NJson::TConfig& config,
                                          const TString& jpoint,
                                          TQueryOpts&& opts = {});
        std::shared_ptr<TDbPool> CreateDb(const NJson::TConfig& config,
                                          const TString& jpointSpecial,
                                          const TString& jpointCommon,
                                          TQueryOpts&& opts = {});

    public:
        void AddUnistat(NUnistat::TBuilder& builder) const;
        void AddUnistatExtended(NUnistat::TBuilder& builder) const;

        TString GetExtendedStats() const;
        TString GetLegacyStats() const;

        std::shared_ptr<TDbPool> CreateDb(const TDbPoolSettings& settings);

    private:
        std::vector<std::shared_ptr<TDbPool>> Dbpools_;

        TDbPoolLog Log_;
    };
}
