#include "db_pool_stats.h"

#include "db_pool.h"
#include "destination.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/generic/yexception.h>
#include <util/string/cast.h>

namespace NPassport::NDbPool {
    static const TString TITLE = "monitoring status";
    TDbPoolStats::TDbPoolStats()
    {
        Init(TITLE);
    }

    TDbPoolStats::TDbPoolStats(const TString& title)
    {
        Init(title);
    }

    TDbPoolStats::~TDbPoolStats() = default;

    void TDbPoolStats::Add(TDbPool* db, const TString& comment) {
        if (Finished_) {
            throw yexception() << "DbPoolStats result is finished!";
        }

        if (!db) {
            return;
        }

        const THandlesInfo info = db->GetHandlesInfo();

        NUtils::Append(
            Buf_,
            "<p>",
            "db_name: ", db->GetDbInfo().DisplayName,
            ", idle: ", info.Idle,
            ", in_use: ", info.InUse,
            ", config_count: ", info.ConfigCount,
            ", comment: ", comment,
            ", dying: ", info.Dying,
            "</p>\r\n");
    }

    const TString& TDbPoolStats::Result() {
        if (!Finished_) {
            Finished_ = true;
            Buf_.append("</body></html>\r\n");
        }

        return Buf_;
    }

    void TDbPoolStats::Init(const TString& title) {
        Buf_ = NUtils::CreateStrExt(1024, "\r\n<html><head><title>", title, "</title></head><body>\r\n");
    }
}
