#include "destination.h"

namespace NPassport::NDbPool {
    TDestinationPtr TDestination::CreateSqlite(const TString& db) {
        return std::make_shared<TDestination>("sqlite", "", "", db, "");
    }

    TDestinationPtr TDestination::CreateHttp(const TString& displayName) {
        return std::make_shared<TDestination>("http", "", "", displayName, "", displayName);
    }

    TDestinationPtr
    TDestination::Create(const TString& driver,
                         const TString& user,
                         const TString& passwd,
                         const TString& db,
                         const TString& locale,
                         const TString& displayName,
                         TDestination::TExtendedParams&& ext) {
        return std::make_shared<TDestination>(
            driver,
            user,
            passwd,
            db,
            locale,
            displayName,
            std::move(ext));
    }
}
