#pragma once

#include <library/cpp/string_utils/secret_string/secret_string.h>

#include <util/generic/string.h>

#include <map>
#include <memory>

namespace NPassport::NDbPool {
    class TDestination;
    using TDestinationPtr = std::shared_ptr<TDestination>;

    class TDestination {
    public:
        using TExtendedParams = std::map<TString, TString>;

        TDestination(
            const TString& driver,
            const TString& user,
            const TString& passwd,
            const TString& db,
            const TString& locale,
            const TString& displayName = "",
            TExtendedParams&& ext = {})
            : Driver(driver)
            , User(user)
            , Passwd(passwd)
            , Db(db)
            , LocaleCmd(locale)
            , Extended(std::move(ext))
            , DisplayName(displayName)
        {
        }

        // default constructor will be deleted implicitly, due to const members, deleting it explicitly
        // http://eel.is/c++draft/class.copy.assign#7
        TDestination(TDestination&&) = delete;
        TDestination& operator=(TDestination&&) = delete;
        TDestination(const TDestination&) = delete;
        TDestination operator=(const TDestination&) = delete;

        static TDestinationPtr CreateSqlite(const TString& db);

        static TDestinationPtr CreateHttp(const TString& displayName = "");

        static TDestinationPtr Create(
            const TString& driver,
            const TString& user,
            const TString& passwd,
            const TString& db,
            const TString& locale,
            const TString& displayName = "",
            TExtendedParams&& ext = {});

        const TString Driver;
        const TString User;
        const NSecretString::TSecretString Passwd;
        const TString Db;
        const TString LocaleCmd;
        const std::map<TString, TString> Extended;
        const TString DisplayName;
    };

    struct TDbHost {
        TString Host;
        ui16 Port = 0;
        size_t Weight = 1;
    };
}
