#pragma once

#include "db_info.h"

#include <util/generic/string.h>
#include <util/generic/yexception.h>

namespace NPassport::NDbPool {
    class TException: public yexception {
    public:
        TException(const TDbInfo& dbInfo) {
            (*this) << dbInfo << ": ";
        }

    protected:
        TException() = default;
    };

    class TCantGetConnection: public TException {
    public:
        using TException::TException;
    };

    class TFormatException: public TException {
    public:
        TFormatException() = default;
    };

    class TNilException: public TException {
    public:
        TNilException() {
            (*this) << "Value is NULL";
        }
    };

    class TTimeoutException: public TException {
    public:
        TTimeoutException(const TDbInfo& dbInfo)
            : TException(dbInfo)
        {
        }
    };
}
