#pragma once

#include <passport/infra/libs/cpp/dbpool/destination.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/system/spinlock.h>

#include <memory>

namespace NPassport::NDbPool {
    class IChooser {
    public:
        using TOptionalIdx = std::optional<size_t>;

        virtual ~IChooser() = default;
        virtual TOptionalIdx TryGetIdx() = 0;
    };
    using TChooserPtr = std::unique_ptr<IChooser>;

    class IChooseFactory {
    public:
        virtual ~IChooseFactory() = default;
        virtual TChooserPtr CreateChooser() = 0;
    };
    using TChooseFactoryPtr = std::unique_ptr<IChooseFactory>;

    class TRandomChooser: public IChooser {
    public:
        struct THostWeight {
            size_t Start = 0;
            size_t Weight = 0;
            size_t Idx = 0;
        };
        using TWeights = TStackVec<THostWeight, 48>;

        struct TState { // NOLINT(bugprone-exception-escape)
            TWeights Weights;
            size_t WeightSum = 0;
        };

        TRandomChooser(const TState& state);

        TOptionalIdx TryGetIdx() override;
        TOptionalIdx TryGetIdx(size_t rnd);

    private:
        TState State_;
    };

    class TRandomFactory: public IChooseFactory {
    public:
        TRandomFactory(const std::vector<TDbHost>& hosts);

        TChooserPtr CreateChooser() override;

        static TRandomChooser::TState PrepareState(const std::vector<TDbHost>& hosts);

        static TChooseFactoryPtr Create(const std::vector<TDbHost>& hosts);

    private:
        const TRandomChooser::TState State_;
    };
}
