#include "counter.h"

#include <passport/infra/libs/cpp/unistat/builder.h>

namespace NPassport::NDbPool {
    TCounters::TCounters(const TString& displayName, ui32 size)
        : ConfigSize(size)
        , AllRequests("dbpool." + displayName + ".requests")
        , CantGetConnection("dbpool." + displayName + ".error.cantgetconnection")
        , QueryTimeout("dbpool." + displayName + ".error.querytimeout")
        , QueryError("dbpool." + displayName + ".error.queryerror")
        , UnistatIdle_("dbpool." + displayName + ".workers.idle", NUnistat::NSuffix::AVVV)
        , UnistatInUse_("dbpool." + displayName + ".workers.inuse", NUnistat::NSuffix::AVVV)
        , UnistatConfig_("dbpool." + displayName + ".workers.config", NUnistat::NSuffix::AVVV)
        , UnistatDying_("dbpool." + displayName + ".workers.dying", NUnistat::NSuffix::AVVV)
    {
    }

    ui32 TCounters::Diff(ui32 l, ui32 r) {
        return l < r ? 0 : l - r;
    }

    void TCounters::AddUnistat(NUnistat::TBuilder& builder) const {
        const ui64 idle = IdleHandles.GetValue();
        const ui64 good = GoodHandles.GetValue();
        const ui64 total = TotalHandles.GetCount();

        builder.AddRow(UnistatIdle_, idle);
        builder.AddRow(UnistatInUse_, Diff(good, idle));
        builder.AddRow(UnistatConfig_, ConfigSize.GetValue());
        builder.AddRow(UnistatDying_, Diff(total, good));

        builder.Add(AllRequests);
        builder.Add(CantGetConnection);
        builder.Add(QueryTimeout);
        builder.Add(QueryError);
    }

    THandlesInfo TCounters::GetHandlesInfo() const {
        const ui64 idle = IdleHandles.GetValue();
        const ui64 good = GoodHandles.GetValue();
        const ui32 total = TotalHandles.GetCount();

        return THandlesInfo{
            .Idle = ui32(idle),
            .Total = total,
            .ConfigCount = (ui32)ConfigSize.GetValue(),
            .Good = ui32(good),
            .Dying = Diff(total, good),
            .InUse = Diff(good, idle),
        };
    }
}
