#pragma once

#include <passport/infra/libs/cpp/dbpool/handles_info.h>

#include <passport/infra/libs/cpp/unistat/absolute.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NDbPool {
    class TSelfCounter {
    public:
        TSelfCounter()
            : Counter_(std::make_shared<NPassport::NUtils::TAtomicNum<>>())
        {
        }

        TSelfCounter(const TSelfCounter& o)
            : Counter_(o.Counter_)
        {
            Inc();
        }

        ~TSelfCounter() {
            Dec();
        }

        TSelfCounter(TSelfCounter&&) = default;

        TSelfCounter& operator=(const TSelfCounter& o) = delete;
        TSelfCounter& operator=(TSelfCounter&& o) = delete;

        ui64 GetCount() const {
            return Counter_->GetValue();
        }

        void Inc() {
            if (Counter_) {
                ++(*Counter_);
            }
        }

        void Dec() {
            if (Counter_) {
                --(*Counter_);
            }
        }

    private:
        std::shared_ptr<NPassport::NUtils::TAtomicNum<>> Counter_;
    };

    class TCounters {
    public:
        TCounters(const TString& displayName, ui32 size);

        void AddUnistat(NUnistat::TBuilder& builder) const;
        THandlesInfo GetHandlesInfo() const;

        NPassport::NUtils::TAtomicNum<> IdleHandles;
        NPassport::NUtils::TAtomicNum<> GoodHandles;
        NPassport::NUtils::TAtomicNum<> ConfigSize;
        TSelfCounter TotalHandles;

        NUnistat::TSignalDiff<> AllRequests;
        NUnistat::TSignalDiff<> CantGetConnection;
        NUnistat::TSignalDiff<> QueryTimeout;
        NUnistat::TSignalDiff<> QueryError;

        static ui32 Diff(ui32 l, ui32 r);

    private:
        const NUnistat::TName UnistatIdle_;
        const NUnistat::TName UnistatInUse_;
        const NUnistat::TName UnistatConfig_;
        const NUnistat::TName UnistatDying_;
    };

    using TCountersPtr = std::shared_ptr<TCounters>;
}
