#pragma once

#include "poolstate.h"

#include <passport/infra/libs/cpp/dbpool/db_info.h>
#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/dbpool/destination.h>
#include <passport/infra/libs/cpp/dbpool/handles_info.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/datetime/base.h>
#include <util/system/event.h>

#include <atomic>
#include <thread>
#include <vector>

namespace NPassport::NDbPool {
    class IChooseFactory;
    class TCounters;
    class IDriver;
    class THandle;
    class THost;

    class TDbPoolImpl {
    public:
        TDbPoolImpl(const TDbPoolSettings& settings,
                    const TDbPoolLog& logger);
        ~TDbPoolImpl();

        const TDbInfo& GetDbInfo() const;

        bool IsOk(TString* statusBuf = nullptr) const;

        THandlesInfo GetHandlesInfo() const;

        void TryPing();

        void GetExtendedStats(NJson::TObject& out) const;
        void AddUnistat(NUnistat::TBuilder& builder) const;
        void AddUnistatExtended(NUnistat::TBuilder& builder) const;

        enum class ECollectHosts {
            Alive,
            Bad,
        };

        using THostSizes = TStackVec<size_t, 48>;
        using THostIdxs = TStackVec<size_t, 48>;

        std::unique_ptr<THandle> Get();
        void Put(std::unique_ptr<THandle> handle);

    protected:
        void InitHosts();

        static void CalculateSizes(const TDbPoolSettings& settings,
                                   const THostIdxs& indexes,
                                   size_t weightSum,
                                   THostSizes& out);

        size_t CalculateState(THostIdxs& hosts, ECollectHosts collect) const;
        void UpdateHostSizes();

        void ServiceThread();

    private:
        TManualEvent WakeUpServiceThread_;

        const TDbPoolSettings Settings_;
        const TDbInfo DbInfo_;
        const size_t WeightSum_;

        std::atomic_bool Exit_;

        const TDbPoolLog Log_;
        mutable TPoolState State_;

        std::shared_ptr<TCounters> Counters_;
        TDbPoolCtx::TTimeStat TimeStats_;

        std::vector<std::unique_ptr<THost>> Hosts_;
        std::unique_ptr<IChooseFactory> ChooseFactory_;

        std::thread Thread_;
    };
}
