#include "driver.h"

#include "http-driver.h"
#include "mysql-driver.h"
#include "sqlite-driver.h"

#include <util/generic/string.h>
#include <util/generic/yexception.h>

namespace NPassport::NDbPool {
    std::unique_ptr<IDriver> IDriver::GetDrv(const TString& n) {
        if (n == "mysql") {
            return std::make_unique<TMysqlDriver>();
        }

        if (n == "sqlite") {
            return std::make_unique<TSqliteDriver>();
        }

        if (n == "http") {
            return std::make_unique<THttpDriver>();
        }

        throw yexception() << "Dbpool: driver not found: " << n;
    }
}
