#pragma once

#include <library/cpp/string_utils/ztstrbuf/ztstrbuf.h>

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <map>
#include <memory>

namespace NPassport::NDbPool {
    class TQuery;
    class TResult;

    class IDriver {
    public:
        using TExtendedArgs = std::map<TString, TString>;

        virtual ~IDriver() = default;

        virtual bool Connect(const TString& host,
                             int port,
                             const TString& user,
                             const TZtStringBuf pwd,
                             const TString& db,
                             TDuration connectTimeout,
                             TDuration queryTimeout,
                             const TExtendedArgs& args,
                             bool fetchStatusOnPing) = 0;

        virtual std::unique_ptr<TResult> Query(const TQuery& query, TDuration queryTimeout) = 0;
        virtual int ErrNum() const = 0;
        virtual TString Error() = 0;
        virtual TString EscapeQueryParam(const TStringBuf) const = 0;
        virtual std::unique_ptr<TResult> Ping(TDuration queryTimeout) = 0;

        static std::unique_ptr<IDriver> GetDrv(const TString& n);
    };
}
