#pragma once

#include "handle.h"
#include "poolstate.h"
#include "queue.h"

#include <passport/infra/libs/cpp/dbpool/db_info.h>
#include <passport/infra/libs/cpp/dbpool/db_pool.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <deque>
#include <memory>

namespace NPassport::NDbPool {
    struct THostSettings {
        TDestinationPtr Dsn;
        TDbHost DbHost;
        TDuration ConnectionTimeout;
        TDuration QueryTimeout;
        TDuration FailThreshold;
        TDuration TimeToInit;
        size_t InitialSize = 0;
        bool FetchStatusOnPing = false;

        TQueryOptsPtr DefaultQueryOpts = std::make_shared<TQueryOpts>();
    };

    enum class EPutHandleStatus {
        Ok,
        Bad,
    };

    struct THostUnistatCtx {
        TDbPoolCtx::TTimeStat PoolTimeStats;
        TCountersPtr PoolCounters;
    };

    class THost {
    public:
        THost(const THostSettings& settings,
              THostUnistatCtx unistat,
              TDbPoolLog log,
              size_t idx);
        ~THost();

        const TDbHost& GetDbHost() const;
        const TDbInfo& GetDbInfo() const;
        bool IsOk() const;
        THandlesInfo GetHandlesInfo() const;

        void AddUnistatExtended(NUnistat::TBuilder& builder) const;

        void TryPing(TDuration getTimeout);

        THandlesInfo GetExtendedStats(NJson::TObject& out) const;

        std::unique_ptr<THandle> TryGetNonblocking();
        EPutHandleStatus Put(std::unique_ptr<THandle> handle);

        THandle::TNonblockingInit CreateHandle() const;
        void PutNewHandle(std::unique_ptr<THandle> handle);

        void CleanupOneBad();

        void SetHandlesCount(ui64 size);

        void ForceDown(bool value);
        void OnPingException();

        static TDbPoolCtx::TTimeStat MakeStats(const TDestination& dsn, const TString& id);

    private:
        void WaitForHandles();
        void PingOneHandle(TDuration getTimeout);

    private:
        const THostSettings Settings_;
        const TDbPoolLog Log_;
        const TDbInfo DbInfo_;

        TPoolState State_;

        std::mutex Mutex_;
        std::mutex MutexBadPool_;

        TQueueWrapper<std::unique_ptr<THandle>> Pool_;
        TQueueWrapper<std::unique_ptr<THandle>> BadPool_;

        THandleUnistatCtx Unistat_;

        size_t Idx_ = 0;
    };

    using THostRefs = std::vector<std::reference_wrapper<THost>>;
}
