#pragma once

#include "driver.h"

#include <contrib/libs/libmysql_r/include/mysql.h>

#include <util/generic/string.h>

namespace NPassport::NDbPool {
    class TQuery;
    struct TRow;

    class TMySqlLibHolder {
    public:
        class TMySqlLibIniter {
        public:
            TMySqlLibIniter() {
                Y_ENSURE(0 == mysql_library_init(0, nullptr, nullptr));
            }

            ~TMySqlLibIniter() {
                mysql_library_end();
            }
        };
        using TLib = std::shared_ptr<TMySqlLibIniter>;

        TMySqlLibHolder()
            : Lib_(std::make_shared<TMySqlLibIniter>())
        {
        }

        TLib Get() const {
            return Lib_;
        }

    private:
        TLib Lib_;
    };

    class TMysqlDriver: public IDriver {
    public:
        TMysqlDriver();

        bool Connect(const TString& host,
                     int port,
                     const TString& user,
                     const TZtStringBuf pwd,
                     const TString& db,
                     TDuration connectTimeout,
                     TDuration queryTimeout,
                     const TExtendedArgs& ext,
                     bool fetchStatusOnPing) override;

        std::unique_ptr<TResult> Query(const TQuery& q, TDuration queryTimeout) override;

        std::unique_ptr<TResult> StoreResult();

        int ErrNum() const override;
        TString Error() override;
        std::unique_ptr<TResult> Ping(TDuration queryTimeout) override;
        TString EscapeQueryParam(const TStringBuf) const override;

        static TString BuildPingQuery(const TExtendedArgs& ext);

    private:
        TRow FetchRow(MYSQL_RES* result_);

    private:
        TString PingQuery_;

        const TMySqlLibHolder::TLib Lib_;

        class TMySqlThreadHolder {
        public:
            TMySqlThreadHolder() {
                Y_ENSURE(0 == mysql_thread_init());
            }

            ~TMySqlThreadHolder() {
                mysql_thread_end();
            }
        } const ThreadHolder_;

        class TMySqlHolder: public MYSQL {
        public:
            TMySqlHolder()
                : MYSQL()
            {
                if (!mysql_init(this)) {
                    TString msg = "mysql_init() failed: ";
                    const char* err = mysql_error(this);
                    msg.append(err ? err : "<no_error>");
                    mysql_close(this);
                    throw yexception() << msg;
                }
            }

            ~TMySqlHolder() {
                mysql_close(this);
            }
        } Handle_;
    };
}
