#pragma once

#include "host.h"

#include <passport/infra/libs/cpp/dbpool/db_info.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/datetime/base.h>
#include <util/system/event.h>

#include <optional>

namespace NPassport::NDbPool {
    class THandle;

    struct TPingGuard {
        TPingGuard(THost& host, std::unique_ptr<THandle> h);
        ~TPingGuard();

        THost& Host;
        std::unique_ptr<THandle> Handle;
        TInstant Start = TInstant::Now();
    };

    class TPingableHost {
    public:
        TPingableHost(TDbPoolLog log,
                      TDuration pingPeriod,
                      TDuration queryTimeout,
                      std::reference_wrapper<THost> host);
        ~TPingableHost();

        const TDbInfo& DbInfo() const;

        TDuration PingNonblocking(const TManualEvent& wakeUpServiceThread);
        void Wait();

    private:
        void StartPing(const TManualEvent& wakeUpServiceThread);
        bool IsPingFinished();
        TInstant GetGuardDeadline() const noexcept;

    private:
        const TDbPoolLog Log_;
        const TDuration PingPeriod_;
        const TDuration QueryTimeout_;

        std::reference_wrapper<THost> Host_;
        std::optional<TPingGuard> Guard_;
        TInstant LastPing_ = TInstant::Now();
    };

    class TPinger {
    public:
        TPinger(TDbPoolLog log,
                TDuration pingPeriod,
                TDuration queryTimeout,
                const THostRefs& hosts);
        ~TPinger();

        TDuration PingNonblocking(const TManualEvent& wakeUpServiceThread);
        void WaitAll();

    private:
        const TDbPoolLog Log_;

        std::vector<std::unique_ptr<TPingableHost>> Hosts_;
    };
}
