#pragma once

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/datetime/base.h>
#include <util/system/spinlock.h>

#include <atomic>

namespace NPassport::NDbPool {
    struct TDbInfo;

    class TPoolState {
    public:
        enum EState {
            Up = 0,
            Down = 1,
            ForceDown = 2,
        };

        enum class ELogLevel {
            Verbose,
            Warn,
        };

        TPoolState(TDbPoolLog log,
                   TDuration failThreshold,
                   const TString& dsn,
                   ELogLevel logLevel = ELogLevel::Verbose);

        void TryMake(EState state, TInstant now = TInstant::Now());
        void TryMakeIfMatch(EState toSet, EState expected, TInstant now = TInstant::Now());
        void TryMakeIfNotMatch(EState toSet, EState expected, TInstant now = TInstant::Now());

        EState CheckState(TDuration& lastChangeTime, TInstant now = TInstant::Now()) const;
        EState GetState() const; // for tests

        static bool IsOk(const TPoolState& state,
                         const TDbInfo& dbInfo,
                         TString* statusBuf = nullptr);

    public:
        class TStateDetails {
        public:
            TInstant GetLastChangingTime() const;
            EState Get() const;
            bool Is(EState state) const;
            void Make(EState state, TInstant now);

        private:
            ui64 Val_ = Up;
        };
        static_assert(sizeof(TStateDetails) == 8, "");

    private:
        void TryMakeImpl(EState toSet, EState expected, bool skipIfExpectedMathched, TInstant now);

    private:
        std::atomic<TStateDetails> State_ = {};
        mutable std::atomic<EState> PrevState_ = Up;

        const TDbPoolLog Log_;
        const TDuration FailThreshold_;
        const TString Dsn_;
        const ELogLevel LogLevel_;
        TAdaptiveLock Spinlock_;
    };
}
