#pragma once

#include "handle.h"
#include "host.h"

#include <passport/infra/libs/cpp/dbpool/db_info.h>
#include <passport/infra/libs/cpp/dbpool/db_pool.h>

#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/datetime/base.h>

#include <optional>

namespace NPassport::NDbPool {
    class THost;

    class TProducableHost {
    public:
        enum ECheckStatus {
            Ok,
            InProgress,
            Failed,
        };

        TProducableHost(TDbPoolLog log,
                        TDuration connectionTimeout,
                        double totalSizeRatio,
                        std::reference_wrapper<THost> host);

        TDuration ProduceNonblocking(const TManualEvent& wakeUpServiceThread);

        const TDbInfo& DbInfo() const {
            return DbInfo_;
        }

        void Wait();

    private:
        ECheckStatus CheckHandleInProcess();
        bool IsHandleReady() const;

        bool NeedMoreHandles() const;

        void CreateNewHandle(const TManualEvent& wakeUpServiceThread);
        void CheckBadHandle();

        TInstant GetHandleDeadline() const noexcept;

    private:
        std::reference_wrapper<THost> Host_;
        const TDbPoolLog Log_;
        const TDuration ConnectionTimeout_;
        const double TotalSizeRatio_;
        const TDbInfo DbInfo_;

        bool IsOk_ = true;
        TInstant FirstFailed_ = TInstant::Now();
        TInstant TryNext_;

        std::optional<THandle::TNonblockingInit> Handle_;
    };

    class TProducer {
    public:
        TProducer(TDbPoolLog log,
                  const TDbPoolSettings& settings,
                  const THostRefs& hosts);
        ~TProducer();

        TDuration ProduceNonblocking(const TManualEvent& wakeUpServiceThread);
        void WaitAll();

    private:
        std::vector<TProducableHost> Hosts_;
        const TDbPoolLog Log_;
    };
}
