#pragma once

#include <passport/infra/libs/cpp/utils/atomic.h>

#include <util/generic/yexception.h>

#include <queue>

namespace NPassport::NDbPool {
    template <typename T>
    class TQueueWrapper {
    public:
        void Push(T h) {
            Data_.push_front(std::move(h));
            Size_.StoreValue(Data_.size());
        }

        T Pop() {
            Y_VERIFY(!Data_.empty());

            T h = std::move(Data_.back());
            Data_.pop_back();
            Size_.StoreValue(Data_.size());

            return h;
        }

        bool IsEmpty() {
            return Data_.empty();
        }

        size_t size() const {
            return Data_.size();
        }

        size_t ThreadSafeSize() const {
            return Size_.GetValue();
        }

        void Clear() {
            Data_.clear();
        }

    private:
        std::deque<T> Data_;
        NUtils::TAtomicNum<> Size_;
    };
}
