#pragma once

#include "driver.h"

#include <passport/infra/libs/cpp/dbpool/value.h>

#include <contrib/libs/sqlite3/sqlite3.h>

#include <util/generic/string.h>

namespace NPassport::NDbPool {
    class TQuery;

    class TSqliteDriver: public IDriver {
    public:
        TSqliteDriver();

        bool Connect(const TString& host,
                     int port,
                     const TString& user,
                     const TZtStringBuf pwd,
                     const TString& db,
                     TDuration connectTimeout,
                     TDuration queryTimeout,
                     const TExtendedArgs& args,
                     bool fetchStatusOnPing) override;

        std::unique_ptr<TResult> Query(const TQuery& q, TDuration queryTimeout) override;
        int ErrNum() const override;
        TString Error() override;
        std::unique_ptr<TResult> Ping(TDuration queryTimeout) override;
        TString EscapeQueryParam(const TStringBuf) const override;

    private:
        bool InitInMemory(const TString& filepath);

    private:
        using TSqlite3Ptr = std::unique_ptr<sqlite3, std::function<int(sqlite3*)>>;

        TSqlite3Ptr Handle_;
    };
}
