#pragma once

#include <util/generic/string.h>

#include <vector>

namespace NPassport::NDbPool {
    class TQuery {
    public:
        static const TString X_YA_SERVICE_TICKET;

        using THttpHeaders = std::vector<TString>; // formated header string: "key: value"

        TQuery(const TString& arg)
            : Query_(arg)
        {
        }

        TQuery(TString&& arg)
            : Query_(std::move(arg))
        {
        }

        TQuery(const char* q)
            : Query_(q)
        {
        }

    private:
        TQuery(const TQuery& o) = default;
        TQuery& operator=(const TQuery&) = default;

    public:
        TQuery() = default;
        TQuery(TQuery&&) = default;

        TQuery& operator=(TQuery&&) = default;

        TQuery Clone() const;

        const TString& Query() const {
            return Query_;
        }

        void SetQuery(const TString& val) {
            Query_ = val;
        }

        void AddHttpHeader(const TString& key, const TString& val);

        void SetHttpBody(TString&& val) {
            HttpBody_ = std::move(val);
        }

        void SetHttpMethod(const TString& val) {
            HttpMethod_ = val;
        }

        const THttpHeaders& HttpHeaders() const {
            return HttpHeaders_;
        }

        const TString& HttpBody() const {
            return HttpBody_;
        }

        const TString& HttpMethod() const {
            return HttpMethod_;
        }

    private:
        TString Query_;

        THttpHeaders HttpHeaders_;
        TString HttpBody_;
        TString HttpMethod_;
    };

    using TQueryOpt = std::function<void(TQuery&)>;
    using TQueryOpts = std::vector<TQueryOpt>;
    using TQueryOptsPtr = std::shared_ptr<TQueryOpts>;
}
