#include "result.h"

#include "exception.h"

namespace NPassport::NDbPool {
    THttpResponse TResult::ToHttpResponse() {
        TTable& table = MutateTable();

        Y_ENSURE_EX(table.size() == 3,
                    TFormatException() << "Unexpected size of response table: " << table.size());
        Y_ENSURE_EX(!table[0].empty(),
                    TFormatException() << "First line is empty");
        Y_ENSURE_EX(!table[2].empty(),
                    TFormatException() << "Response body is empty");

        // first line: status && content_type
        // third line: body
        return THttpResponse{
            .Status = table[0][0].AsInt(),
            .Body = std::move(table[2][0].AsMutableString()),
        };
    }

    TPingResult TResult::ToPingResult() const {
        const TTable& t = Table();

        Y_ENSURE_EX(t.size() == 1,
                    TFormatException() << "Unexpected size of response table: " << t.size());
        Y_ENSURE_EX(t[0].size() == 1,
                    TFormatException() << "Unexpected size of row: " << t[0].size());

        return TPingResult{
            .IsOk = (bool)t[0][0].AsInt(),
        };
    }
}
