#pragma once

#include "http_response.h"
#include "ping_result.h"
#include "value.h"

#include <util/datetime/base.h>

namespace NPassport::NDbPool {
    class TResult {
    public:
        TResult(TTable table, size_t affectedRows = 0)
            : Table_(std::move(table))
            , ReadyTime_(TInstant::Now())
            , AffectedRows_(affectedRows)
        {
        }

        int size() const {
            Y_ENSURE(Table_, ERR_MSG);
            return Table_->size();
        }

        size_t AffectedRows() const {
            return AffectedRows_;
        }

        template <class... Types>
        bool Fetch(Types&... args) {
            Y_ENSURE(Table_, ERR_MSG);
            if (Idx_ >= Table_->size()) {
                return false;
            }

            (*Table_)[Idx_++].Fetch(args...);
            return true;
        }

        const TTable& Table() const {
            Y_ENSURE(Table_, ERR_MSG);
            return *Table_;
        }

        TTable& MutateTable() {
            Y_ENSURE(Table_, ERR_MSG);
            return *Table_;
        }

        TTable ExctractTable() {
            Y_ENSURE(Table_, ERR_MSG);

            TTable res = std::move(*Table_);
            Table_.reset();

            return res;
        }

        THttpResponse ToHttpResponse();
        TPingResult ToPingResult() const;

        TInstant GetReadyTime() const {
            return ReadyTime_;
        }

    private:
        std::optional<TTable> Table_;
        TInstant ReadyTime_;

        size_t Idx_ = 0;

        const size_t AffectedRows_;

        static const inline char* const ERR_MSG = "table has been already extracted";
    };
}
