#include <passport/infra/libs/cpp/dbpool/misc/mysql-driver.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NDbPool;

Y_UNIT_TEST_SUITE(MysqlDriver) {
    Y_UNIT_TEST(buildPingQuery) {
        UNIT_ASSERT_VALUES_EQUAL(
            "SELECT value FROM db_status LIMIT 1",
            TMysqlDriver::BuildPingQuery({}));
        UNIT_ASSERT_VALUES_EQUAL(
            "SELECT value FROM foo LIMIT 1",
            TMysqlDriver::BuildPingQuery({
                {"status_table", "foo"},
            }));
        UNIT_ASSERT_VALUES_EQUAL(
            "SELECT bar FROM db_status LIMIT 1",
            TMysqlDriver::BuildPingQuery({
                {"status_column", "bar"},
            }));
        UNIT_ASSERT_VALUES_EQUAL(
            "SELECT bar FROM foo LIMIT 1",
            TMysqlDriver::BuildPingQuery({
                {"status_table", "foo"},
                {"status_column", "bar"},
            }));
    }
}
