#include <passport/infra/libs/cpp/dbpool/result.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NDbPool;

Y_UNIT_TEST_SUITE(Result) {
    Y_UNIT_TEST(size) {
        TTable table;
        {
            TRow r;
            r.push_back(TValue("kek"));
            r.push_back(TValue("kek2"));
            table.push_back(std::move(r));
        }

        TResult res(std::move(table));
        UNIT_ASSERT_VALUES_EQUAL(1, res.size());

        TResult empty({});
        UNIT_ASSERT_VALUES_EQUAL(0, empty.size());
    }

    Y_UNIT_TEST(fetch) {
        TTable table;

        {
            TRow r;
            r.push_back(TValue("kek"));
            r.push_back(TValue("kek2"));
            table.push_back(std::move(r));
        }
        TResult res(std::move(table));

        UNIT_ASSERT_VALUES_EQUAL(1, res.Table().size());
        const TRow& row = res.Table()[0];
        UNIT_ASSERT_VALUES_EQUAL(2, row.size());
        UNIT_ASSERT_VALUES_EQUAL("kek", row[0].AsString());
        UNIT_ASSERT_VALUES_EQUAL("kek2", row[1].AsString());

        TResult empty({});
        UNIT_ASSERT_VALUES_EQUAL(0, empty.size());
    }

    Y_UNIT_TEST(fetchTuple) {
        TTable table;

        {
            TRow r;
            r.push_back(TValue("kek"));
            r.push_back(TValue("190"));
            table.push_back(std::move(r));
        }
        TResult res(std::move(table));

        TString col1;
        int col2;
        UNIT_ASSERT(res.Fetch(col1, col2));
        UNIT_ASSERT_VALUES_EQUAL("kek", col1);
        UNIT_ASSERT_VALUES_EQUAL(190, col2);
        UNIT_ASSERT(!res.Fetch(col1, col2));

        TResult empty({});
        UNIT_ASSERT(!empty.Fetch(col1, col2));
    }

    Y_UNIT_TEST(fetchTupleNullable) {
        TTable table;
        {
            TRow r;
            r.push_back(TValue({}, true));
            r.push_back(TValue({}, true));
            r.push_back(TValue("42"));
            table.push_back(std::move(r));
        }
        {
            TRow r;
            r.push_back(TValue("asd"));
            r.push_back(TValue("123"));
            r.push_back(TValue("43"));
            table.push_back(std::move(r));
        }
        TResult withNullable(std::move(table));

        std::optional<TString> optString;
        std::optional<ui64> optNum;
        ui64 num = 0;

        UNIT_ASSERT(withNullable.Fetch(optString, optNum, num));
        UNIT_ASSERT(!optString);
        UNIT_ASSERT(!optNum);
        UNIT_ASSERT_VALUES_EQUAL(42, num);

        UNIT_ASSERT(withNullable.Fetch(optString, optNum, num));
        UNIT_ASSERT(optString);
        UNIT_ASSERT_VALUES_EQUAL("asd", *optString);
        UNIT_ASSERT(optNum);
        UNIT_ASSERT_VALUES_EQUAL(123, *optNum);
        UNIT_ASSERT_VALUES_EQUAL(43, num);

        UNIT_ASSERT(!withNullable.Fetch(optString, optNum, num));
    }

    Y_UNIT_TEST(exctractTable) {
        TTable tmp;

        {
            TRow r;
            r.push_back(TValue("kek"));
            r.push_back(TValue("190"));
            tmp.push_back(std::move(r));
        }
        TResult res(std::move(tmp));

        TTable table = res.ExctractTable();
        UNIT_ASSERT_VALUES_EQUAL(1, table.size());
        UNIT_ASSERT_VALUES_EQUAL(2, table[0].size());
        UNIT_ASSERT_VALUES_EQUAL("kek", table[0][0].AsString());
        UNIT_ASSERT_VALUES_EQUAL("190", table[0][1].AsString());
        UNIT_ASSERT_EXCEPTION_CONTAINS(res.ExctractTable(),
                                       yexception,
                                       "table has been already extracted");

        TResult empty({});
        table = empty.ExctractTable();
        UNIT_ASSERT_VALUES_EQUAL(0, table.size());
    }

    Y_UNIT_TEST(affectedRows) {
        TResult res({}, 5);
        UNIT_ASSERT_VALUES_EQUAL(0, res.size());
        UNIT_ASSERT_VALUES_EQUAL(5, res.AffectedRows());
        TTable table;
        UNIT_ASSERT_NO_EXCEPTION(table = res.ExctractTable());
        UNIT_ASSERT_VALUES_EQUAL(0, table.size());
        UNIT_ASSERT_EXCEPTION_CONTAINS(res.ExctractTable(),
                                       yexception,
                                       "table has been already extracted");

        TTable table1;
        for (int i = 0; i < 5; ++i) {
            table1.emplace_back();
        }

        TResult res1(std::move(table1));
        UNIT_ASSERT_VALUES_EQUAL(5, res1.size());
        UNIT_ASSERT_VALUES_EQUAL(0, res1.AffectedRows());
    }
}
