#include "db_pool.h"
#include "handle.h"
#include "result.h"

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NDbPool;

Y_UNIT_TEST_SUITE(Sqlite3Driver) {
    class TDbHolder {
    public:
        TDbHolder() {
            Pool = std::make_unique<TDbPool>(TDbPoolSettings{
                .Dsn = TDestination::CreateSqlite(
                    ArcadiaSourceRoot() + "/passport/infra/libs/cpp/dbpool/ut/db/driver.sqlite3.sql"),
            });

            Pool->TryPing();
            H = std::make_unique<TBlockingHandle>(*Pool);
        }

        std::unique_ptr<TDbPool> Pool;
        std::unique_ptr<TBlockingHandle> H;
    };

    struct TCase {
        TString In;
        size_t Out;
    };

    Y_UNIT_TEST(Initialization) {
        UNIT_ASSERT_NO_EXCEPTION(TDbHolder());
    }

    Y_UNIT_TEST(AffectedRowsDelete) {
        TDbHolder db;
        std::vector<TCase> cases = {
            {R"(delete from table1 where col2='asdf' limit 1;)", 1},
            {R"(delete from table1 where col2='asdf' limit 1;)", 1},
            {R"(delete from table1 where col2='asdf' limit 1;)", 0},
            {R"(delete from table1 where col2='fdas';)", 2},
        };

        for (const TCase& c : cases) {
            std::unique_ptr<TResult> res = db.H->Query({c.In});
            UNIT_ASSERT_VALUES_EQUAL(c.Out, res->AffectedRows());
        }
    }
}
