#pragma once

#include "query.h"

#include <util/datetime/base.h>
#include <util/generic/string.h>
#include <util/system/types.h>

#include <memory>
#include <time.h>

namespace NPassport::NDbPool {
    class TDbPool;
    class TResult;
}

namespace NPassport::NDbPool::NUtils {
    struct TResponseWithRetries {
        std::unique_ptr<NDbPool::TResult> Result;
        TDuration LastResponseTime;
        size_t Retries = 0;
    };

    TResponseWithRetries DoQueryTries(NDbPool::TDbPool& db,
                                      const TQuery& query,
                                      ui16 tries = 3);

    TString GetHttpBody(TDbPool& db,
                        TQuery&& query,
                        const char* errMsg);

    bool FetchBodyFromHttpResult(std::unique_ptr<TResult> result,
                                 const TStringBuf path,
                                 TString& output,
                                 TString& errMsg);
}
