#include "value.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NDbPool {
    const TString& TValue::AsString() const {
        return const_cast<TValue*>(this)->AsMutableString();
    }

    TString& TValue::AsMutableString() {
        if (IsNull_) {
            throw TNilException();
        }

        return Val_;
    }

    TString TRow::DebugString() const {
        TString res;

        for (const TValue& v : *this) {
            NPassport::NUtils::AppendSeparated(res, ';', v.IsNull() ? "<NULL>" : v.AsString());
        }

        return res;
    }
}
