LIBRARY()

OWNER(g:passport_infra)

CFLAGS(
    -D_REENTRANT
)

PEERDIR(
    contrib/libs/curl
    contrib/libs/libmysql_r
    contrib/libs/sqlite3
    library/cpp/string_utils/secret_string
    library/cpp/threading/future
    passport/infra/libs/cpp/json
    passport/infra/libs/cpp/unistat
    passport/infra/libs/cpp/utils
    passport/infra/libs/cpp/xml
)

SRCS(
    db_info.cpp
    db_pool.cpp
    db_pool_ctx.cpp
    db_pool_stats.cpp
    destination.cpp
    misc/choose_policy.cpp
    misc/counter.cpp
    misc/db_pool.cpp
    misc/driver.cpp
    misc/handle.cpp
    misc/host.cpp
    misc/http-driver.cpp
    misc/mysql-driver.cpp
    misc/pinger.cpp
    misc/poolstate.cpp
    misc/producer.cpp
    misc/sqlite-driver.cpp
    query.cpp
    result.cpp
    util.cpp
    value.cpp
)

GENERATE_ENUM_SERIALIZATION(misc/poolstate.h)

END()

RECURSE_FOR_TESTS(
    ut
)
